SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_OWNER_RECIPIENTS');
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
        T1.id AS ID,
        T1.code AS ENQUIRY_CODE,
        T1.firstName AS STUDENT_FIRSTNAME,
        T1.lastName AS STUDENT_LASTNAME,
        T2.fatherFirstName AS PARENT_FIRSTNAME,
        T2.fatherLastName AS PARENT_LASTNAME, 
        T4.firstName as FIRST_NAME,
        T4.lastName as LAST_NAME,
        T4.emailId AS EMAIL_ID,
        T4.mobileNumber AS MOBILE_NO,
        T2.mobileCountryCode AS MOBILE_CODE,
        T5.displayName AS ACADEMY_NAME_LOCATION,
        CONCAT(T7.addressText,' ',T8.cityName,', ',T9.countryName,', ',T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
		CONCAT(T7.phoneCountryCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
		T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
        T5.academyName AS ACADEMY_NAME,
    (Case 
    when T5.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T5.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T5.logoUrl)end) as LOGO_URL,
    (Case when T5.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T5.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.footerUrl) 
    else NULL end) as FOOTER_URL       
    FROM
        enquiry T1
            LEFT JOIN
        enq_student_details T2 ON T2.enquiryId = T1.id    
            LEFT JOIN 
        staffs T3 on T1.assignedToUserId=T3.userId
            LEFT JOIN
        persons T4 on T4.id=T3.personId
            LEFT JOIN
        academy_location T5 ON T5.id = T1.academyLocationId
            LEFT JOIN
        academy_location_addresses T6 ON T6.academyLocationId = T5.id
			LEFT OUTER JOIN
		address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
			LEFT OUTER JOIN
		city T8 ON T8.id = T7.cityId
			LEFT OUTER JOIN
		country T9 ON T9.id = T8.countryId
			LEFT OUTER JOIN
		country_region T10 ON T10.id = T8.countryRegionId
            LEFT JOIN
        organizations org on org.id = 1
    WHERE
        T1.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "STUDENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "STUDENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 4
        },{
            "id": 6,
            "value": "studentLastName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 5
        },{
            "id": 7,
            "value": "studentLastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "Academy Location Phone No.",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "Academy Location Email Id",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
}' WHERE (`dataProviderId` = @dtproviderId);
SET SQL_SAFE_UPDATES=1;